// TODO : falta incluir controlador de errores en AgregarNumero
#ifndef DSTRING_H
    #define DSTRING_H

    #include "DError.h"
    #include <string>
    #include <sstream>

    namespace DWL {


        class DStringWC;

        class DStringMB : public DObjeto {
          public :
                                                DStringMB(void)                                                                             { };
                                                DStringMB(const char Orig)                                                                  { CopiarChar(Orig); };
                                                DStringMB(const wchar_t Orig)                                                               { CopiarChar(Orig); };
                                                DStringMB(const char *Orig)                                                                 { CopiarString(Orig); };
                                                DStringMB(const std::string &Orig)                                                          { CopiarString(Orig.c_str()); };
                                                DStringMB(const DStringMB &Orig)                                                            { CopiarString(Orig._Text); };
                                                DStringMB(const wchar_t *Orig)                                                              { _AgregarStringWide(Orig); };
                                                DStringMB(const std::wstring &Orig)                                                         { _AgregarStringWide(Orig); };
                                                DStringMB(const DStringWC &Orig)                                                            { _AgregarStringWide(Orig); };
                                                DStringMB(const short Orig)                                                                 { AgregarNumero(Orig); };
                                                DStringMB(const unsigned short Orig)                                                        { AgregarNumero(Orig); };
                                                DStringMB(const int Orig)                                                                   { AgregarNumero(Orig); };
                                                DStringMB(const unsigned int Orig)                                                          { AgregarNumero(Orig); };
                                                DStringMB(const long Orig)                                                                  { AgregarNumero(Orig); };
                                                DStringMB(const unsigned long Orig)                                                         { AgregarNumero(Orig); };
                                                DStringMB(const long long Orig)                                                             { AgregarNumero(Orig); };
                                                DStringMB(const unsigned long long Orig)                                                    { AgregarNumero(Orig); };
                                                DStringMB(const float Orig)                                                                 { AgregarNumero(Orig); };
                                                DStringMB(const double Orig)                                                                { AgregarNumero(Orig); };
            virtual                            ~DStringMB(void) { };

            inline const size_t                 AgregarChar(const char NuevoChar)                                                           { _Text += NuevoChar; return _Text.size(); };
            const size_t                        AgregarChar(const wchar_t NuevoChar);

            const size_t                        AgregarString(const char *NuevoString); 
            inline const size_t                 AgregarString(const std::string &NuevoString)                                               { return AgregarString(NuevoString.c_str()); };
            inline const size_t                 AgregarString(const DStringMB &NuevoString)                                                 { return AgregarString(NuevoString._Text); };
            inline const size_t                 AgregarString(const wchar_t *NuevoString, size_t NewSize = DWL_STR_MAX)                     { return _AgregarStringWide(NuevoString, NewSize); };
            inline const size_t                 AgregarString(const std::wstring &NuevoString)                                              { return _AgregarStringWide(NuevoString); };
            inline const size_t                 AgregarString(const DStringWC &NuevoString)                                                 { return _AgregarStringWide(NuevoString); };

            template <class T> const size_t     AgregarNumero(const T &NuevoNumero)                                                         { std::stringstream ss; ss << NuevoNumero; _Text += ss.str(); return _Text.size(); };

            inline const size_t                 CopiarChar(const char NuevoChar)                                                            { _Text = NuevoChar; return _Text.size(); };
            const size_t                        CopiarChar(const wchar_t NuevoChar);

            const size_t                        CopiarString(const char *NuevoString);
            inline const size_t                 CopiarString(const std::string &NuevoString)                                                { return CopiarString(NuevoString.c_str()); };
            inline const size_t                 CopiarString(const DStringMB &NuevoString)                                                  { return CopiarString(NuevoString._Text); };
            inline const size_t                 CopiarString(const wchar_t *NuevoString, size_t NewSize = DWL_STR_MAX)                      { _Text.clear(); return _AgregarStringWide(NuevoString, NewSize); };
            inline const size_t                 CopiarString(const std::wstring &NuevoString)                                               { _Text.clear(); return _AgregarStringWide(NuevoString); };
            inline const size_t                 CopiarString(const DStringWC &NuevoString)                                                  { _Text.clear(); return _AgregarStringWide(NuevoString); };

            DStringWC                           WideChar(void);
//            DStringWC                           ToMultiByte(void);

            DStringMB                           SubStr(const size_t nInicio, const size_t TotalCaracteres = 0);

            inline const size_t                 Tam(void) const                                                                             { return _Text.size(); };
            inline void                         Borrar(void)                                                                                { _Text.clear(); };
            inline const char                  *Texto(void) const                                                                           { return _Text.c_str(); };

            inline const int                    Comparar(const char *NuevoString, bool ModoBinario = true)                                  { if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), NuevoString); else return _CompararBinario(_Text.c_str(), NuevoString); };
            inline const int                    Comparar(const DStringMB &NuevoString, bool ModoBinario = true)                             { if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), NuevoString()); else return _CompararBinario(_Text.c_str(), NuevoString()); };
            inline const int                    Comparar(const std::string &NuevoString, bool ModoBinario = true)                           { if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), NuevoString.c_str()); else return _CompararBinario(_Text.c_str(), NuevoString.c_str()); };
            inline const int                    Comparar(const wchar_t *NuevoString, bool ModoBinario = true)                               { DStringMB C2 = NuevoString; if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), C2()); else return _CompararBinario(_Text.c_str(), C2()); };
            inline const int                    Comparar(const DStringWC &NuevoString, bool ModoBinario = true)                             { DStringMB C2 = NuevoString; if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), C2()); else return _CompararBinario(_Text.c_str(), C2()); };
            inline const int                    Comparar(const std::wstring &NuevoString, bool ModoBinario = true)                          { DStringMB C2 = NuevoString; if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), C2()); else return _CompararBinario(_Text.c_str(), C2()); };

            inline const char                  *operator () (void) const                                                                    { return _Text.c_str(); };
            inline char                        &operator [] (const size_t nPos)                                                             { if (nPos > _Text.size()) { throw(DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_IndiceInvalido)); return _Text[_Text.size() - 1]; } return _Text[nPos]; };

            inline DStringMB                   &operator = (const char NuevoChar)                                                           { CopiarChar(NuevoChar); return *this; };
            inline DStringMB                   &operator = (const wchar_t NuevoChar)                                                        { CopiarChar(NuevoChar); return *this; };
            inline DStringMB                   &operator = (const char *NuevoString)                                                        { CopiarString(NuevoString); return *this; };
            inline DStringMB                   &operator = (const std::string &NuevoString)                                                 { CopiarString(NuevoString.c_str()); return *this; };
            inline DStringMB                   &operator = (const DStringMB &NuevoString)                                                   { CopiarString(NuevoString._Text); return *this; };
            inline DStringMB                   &operator = (const wchar_t *NuevoString)                                                     { _Text.clear(); _AgregarStringWide(NuevoString); return *this; };
            inline DStringMB                   &operator = (const std::wstring &NuevoString)                                                { _Text.clear(); _AgregarStringWide(NuevoString); return *this; };
            inline DStringMB                   &operator = (const DStringWC &NuevoString)                                                   { _Text.clear(); _AgregarStringWide(NuevoString); return *this; };
            inline DStringMB                   &operator = (const short NuevoNumero)                                                        { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator = (const unsigned short NuevoNumero)                                               { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator = (const int NuevoNumero)                                                          { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator = (const unsigned int NuevoNumero)                                                 { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator = (const long NuevoNumero)                                                         { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator = (const unsigned long NuevoNumero)                                                { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator = (const long long NuevoNumero)                                                    { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator = (const unsigned long long NuevoNumero)                                           { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator = (const float NuevoNumero)                                                        { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator = (const double NuevoNumero)                                                       { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };

            inline DStringMB                   &operator += (const char NuevoChar)                                                          { AgregarChar(NuevoChar); return *this; };
            inline DStringMB                   &operator += (const wchar_t NuevoChar)                                                       { AgregarChar(NuevoChar); return *this; };
            inline DStringMB                   &operator += (const char *NuevoString)                                                       { AgregarString(NuevoString); return *this; };
            inline DStringMB                   &operator += (const std::string &NuevoString)                                                { AgregarString(NuevoString.c_str()); return *this; };
            inline DStringMB                   &operator += (const DStringMB &NuevoString)                                                  { AgregarString(NuevoString._Text); return *this; };
            inline DStringMB                   &operator += (const wchar_t *NuevoString)                                                    { _AgregarStringWide(NuevoString); return *this; };
            inline DStringMB                   &operator += (const std::wstring &NuevoString)                                               { _AgregarStringWide(NuevoString); return *this; };
            inline DStringMB                   &operator += (const DStringWC &NuevoString)                                                  { _AgregarStringWide(NuevoString); return *this; };
            inline DStringMB                   &operator += (const short NuevoNumero)                                                       { AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator += (const unsigned short NuevoNumero)                                              { AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator += (const int NuevoNumero)                                                         { AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator += (const unsigned int NuevoNumero)                                                { AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator += (const long NuevoNumero)                                                        { AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator += (const unsigned long NuevoNumero)                                               { AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator += (const long long NuevoNumero)                                                   { AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator += (const unsigned long long NuevoNumero)                                          { AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator += (const float NuevoNumero)                                                       { AgregarNumero(NuevoNumero); return *this; };
            inline DStringMB                   &operator += (const double NuevoNumero)                                                      { AgregarNumero(NuevoNumero); return *this; };

            inline bool                         operator == (const char *NuevoString)                                                       { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const std::string &NuevoString)                                                { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const DStringMB &NuevoString)                                                  { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const wchar_t *NuevoString)                                                    { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const std::wstring &NuevoString)                                               { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const DStringWC &NuevoString)                                                  { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator != (const char *NuevoString)                                                       { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const std::string &NuevoString)                                                { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const DStringMB &NuevoString)                                                  { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const wchar_t *NuevoString)                                                    { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const std::wstring &NuevoString)                                               { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const DStringWC &NuevoString)                                                  { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }

            virtual const TCHAR                *Objeto_Nombre(void) { return TEXT("DStringMB"); };
            virtual const DEnum_Objeto          Objeto_ID(void)     { return DEnum_Objeto_StringMB; };

          protected :
            const size_t                       _AgregarStringWide(const wchar_t *NuevoString, const size_t NewSize = DWL_STR_MAX);
            inline const size_t                _AgregarStringWide(const std::wstring &NuevoString)                                          { return _AgregarStringWide(NuevoString.c_str(), NuevoString.size()); };
            const size_t                       _AgregarStringWide(const DStringWC &NuevoString);
            const int                          _CompararBinario(const char *String1, const char *String2) const;
            const int                          _CompararInsensitivo(const char *String1, const char *String2) const;
            std::string                        _Text;
        };




        class DStringWC : public DObjeto {
          public :
                                                DStringWC(void)                                                                             { };
                                                DStringWC(const wchar_t Orig)                                                               { CopiarChar(Orig); };
                                                DStringWC(const char Orig)                                                                  { CopiarChar(Orig); };
                                                DStringWC(const wchar_t *Orig)                                                              { CopiarString(Orig); };
                                                DStringWC(const std::wstring &Orig)                                                         { CopiarString(Orig.c_str()); };
                                                DStringWC(const DStringWC &Orig)                                                            { CopiarString(Orig._Text); };
                                                DStringWC(const char *Orig)                                                                 { _AgregarStringMultiByte(Orig); };
                                                DStringWC(const std::string &Orig)                                                          { _AgregarStringMultiByte(Orig); };
                                                DStringWC(const DStringMB &Orig)                                                            { _AgregarStringMultiByte(Orig); };
                                                DStringWC(const short Orig)                                                                 { AgregarNumero(Orig); };
                                                DStringWC(const unsigned short Orig)                                                        { AgregarNumero(Orig); };
                                                DStringWC(const int Orig)                                                                   { AgregarNumero(Orig); };
                                                DStringWC(const unsigned int Orig)                                                          { AgregarNumero(Orig); };
                                                DStringWC(const long Orig)                                                                  { AgregarNumero(Orig); };
                                                DStringWC(const unsigned long Orig)                                                         { AgregarNumero(Orig); };
                                                DStringWC(const long long Orig)                                                             { AgregarNumero(Orig); };
                                                DStringWC(const unsigned long long Orig)                                                    { AgregarNumero(Orig); };
                                                DStringWC(const float Orig)                                                                 { AgregarNumero(Orig); };
                                                DStringWC(const double Orig)                                                                { AgregarNumero(Orig); };
            virtual                            ~DStringWC(void) { };

            inline const size_t                 AgregarChar(const wchar_t NuevoChar)                                                        { _Text += NuevoChar; return _Text.size(); };
            const size_t                        AgregarChar(const char NuevoChar);

            const size_t                        AgregarString(const wchar_t *NuevoString);
            inline const size_t                 AgregarString(const std::wstring &NuevoString)                                              { return AgregarString(NuevoString.c_str()); };
            inline const size_t                 AgregarString(const DStringWC &NuevoString)                                                 { return AgregarString(NuevoString._Text); return _Text.size(); };
            inline const size_t                 AgregarString(const char *NuevoString, size_t NewSize = DWL_STR_MAX)                        { return _AgregarStringMultiByte(NuevoString, NewSize);  };
            inline const size_t                 AgregarString(const std::string &NuevoString)                                               { return _AgregarStringMultiByte(NuevoString.c_str(), NuevoString.size()); };
            inline const size_t                 AgregarString(const DStringMB &NuevoString)                                                 { return _AgregarStringMultiByte(NuevoString(), NuevoString.Tam()); };

            template <class T> const size_t     AgregarNumero(const T &NuevoNumero)                                                         { std::stringstream ss;    ss << NuevoNumero; _AgregarStringMultiByte(ss.str()); return _Text.size(); };

            inline const size_t                 CopiarChar(const wchar_t NuevoChar)                                                         { _Text = NuevoChar; return _Text.size(); };
            const size_t                        CopiarChar(const char NuevoChar);

            const size_t                        CopiarString(const wchar_t *NuevoString);
            inline const size_t                 CopiarString(const std::wstring &NuevoString)                                               { return CopiarString(NuevoString.c_str()); };
            inline const size_t                 CopiarString(const DStringWC &NuevoString)                                                  { return CopiarString(NuevoString._Text); };
            inline const size_t                 CopiarString(const char *NuevoString, size_t NewSize = DWL_STR_MAX)                         { _Text.clear(); return _AgregarStringMultiByte(NuevoString, NewSize); };
            inline const size_t                 CopiarString(const std::string &NuevoString)                                                { _Text.clear(); return _AgregarStringMultiByte(NuevoString); };
            inline const size_t                 CopiarString(const DStringMB &NuevoString)                                                  { _Text.clear(); return _AgregarStringMultiByte(NuevoString); };

            inline DStringMB                    MultiByte(void)                                                                             { return DStringMB(_Text); };
//            inline DStringMB                    ToWideChar(void)                                                                { return DStringMB(_Text); };

            DStringWC                           SubStr(const size_t nInicio, const size_t TotalCaracteres = 0);

            inline const size_t                 Tam(void) const                                                                             { return _Text.size(); };
            inline void                         Borrar(void)                                                                                { _Text.clear(); };
            inline const wchar_t               *Texto(void) const                                                                           { return _Text.c_str(); };

            inline const int                    Comparar(const wchar_t *NuevoString, bool ModoBinario = false)                              { if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), NuevoString); else return _CompararBinario(_Text.c_str(), NuevoString); };
            inline const int                    Comparar(const DStringWC &NuevoString, bool ModoBinario = false)                            { if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), NuevoString()); else return _CompararBinario(_Text.c_str(), NuevoString()); };
            inline const int                    Comparar(const std::wstring &NuevoString, bool ModoBinario = false)                         { if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), NuevoString.c_str()); else return _CompararBinario(_Text.c_str(), NuevoString.c_str()); };
            inline const int                    Comparar(const char *NuevoString, bool ModoBinario = false)                                 { DStringWC C2 = NuevoString; if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), C2()); else return _CompararBinario(_Text.c_str(), C2()); };
            inline const int                    Comparar(const DStringMB &NuevoString, bool ModoBinario = false)                            { DStringWC C2 = NuevoString; if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), C2()); else return _CompararBinario(_Text.c_str(), C2()); };
            inline const int                    Comparar(const std::string &NuevoString, bool ModoBinario = false)                          { DStringWC C2 = NuevoString; if (ModoBinario == false) return _CompararInsensitivo(_Text.c_str(), C2()); else return _CompararBinario(_Text.c_str(), C2()); };

            inline const wchar_t               *operator () (void) const                                                                    { return _Text.c_str(); };
            inline wchar_t                     &operator [] (const size_t nPos)                                                             { if (nPos > _Text.size()) { throw(DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_IndiceInvalido)); return _Text[_Text.size() - 1]; } return _Text[nPos]; };

            inline DStringWC                   &operator = (const wchar_t NuevoChar)                                                        { CopiarChar(NuevoChar); return *this; };
            inline DStringWC                   &operator = (const char NuevoChar)                                                           { CopiarChar(NuevoChar); return *this; };
            inline DStringWC                   &operator = (const wchar_t *NuevoString)                                                     { CopiarString(NuevoString); return *this; };
            inline DStringWC                   &operator = (const std::wstring &NuevoString)                                                { CopiarString(NuevoString.c_str()); return *this; };
            inline DStringWC                   &operator = (const DStringWC &NuevoString)                                                   { CopiarString(NuevoString._Text); return *this; };
            inline DStringWC                   &operator = (const char *NuevoString)                                                        { _Text.clear(); _AgregarStringMultiByte(NuevoString); return *this; };
            inline DStringWC                   &operator = (const std::string &NuevoString)                                                 { _Text.clear(); _AgregarStringMultiByte(NuevoString); return *this; };
            inline DStringWC                   &operator = (const DStringMB &NuevoString)                                                   { _Text.clear(); _AgregarStringMultiByte(NuevoString); return *this; };
            inline DStringWC                   &operator = (const short NuevoNumero)                                                        { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator = (const unsigned short NuevoNumero)                                               { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator = (const int NuevoNumero)                                                          { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator = (const unsigned int NuevoNumero)                                                 { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator = (const long NuevoNumero)                                                         { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator = (const unsigned long NuevoNumero)                                                { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator = (const long long NuevoNumero)                                                    { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator = (const unsigned long long NuevoNumero)                                           { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator = (const float NuevoNumero)                                                        { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator = (const double NuevoNumero)                                                       { _Text.clear(); AgregarNumero(NuevoNumero); return *this; };

            inline DStringWC                   &operator += (const wchar_t NuevoChar)                                                       { AgregarChar(NuevoChar); return *this; };
            inline DStringWC                   &operator += (const char NuevoChar)                                                          { AgregarChar(NuevoChar); return *this; };
            inline DStringWC                   &operator += (const wchar_t *NuevoString)                                                    { AgregarString(NuevoString); return *this; };
            inline DStringWC                   &operator += (const std::wstring &NuevoString)                                               { AgregarString(NuevoString.c_str()); return *this; };
            inline DStringWC                   &operator += (const DStringWC &NuevoString)                                                  { AgregarString(NuevoString._Text); return *this; };
            inline DStringWC                   &operator += (const char *NuevoString)                                                       { _AgregarStringMultiByte(NuevoString); return *this; };
            inline DStringWC                   &operator += (const std::string &NuevoString)                                                { _AgregarStringMultiByte(NuevoString); return *this; };
            inline DStringWC                   &operator += (const DStringMB &NuevoString)                                                  { _AgregarStringMultiByte(NuevoString); return *this; };
            inline DStringWC                   &operator += (const short NuevoNumero)                                                       { AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator += (const unsigned short NuevoNumero)                                              { AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator += (const int NuevoNumero)                                                         { AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator += (const unsigned int NuevoNumero)                                                { AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator += (const long NuevoNumero)                                                        { AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator += (const unsigned long NuevoNumero)                                               { AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator += (const long long NuevoNumero)                                                   { AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator += (const unsigned long long NuevoNumero)                                          { AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator += (const float NuevoNumero)                                                       { AgregarNumero(NuevoNumero); return *this; };
            inline DStringWC                   &operator += (const double NuevoNumero)                                                      { AgregarNumero(NuevoNumero); return *this; };

            inline bool                         operator == (const char *NuevoString)                                                       { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const std::string &NuevoString)                                                { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const DStringMB &NuevoString)                                                  { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const wchar_t *NuevoString)                                                    { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const std::wstring &NuevoString)                                               { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator == (const DStringWC &NuevoString)                                                  { int C = Comparar(NuevoString); if (C == 0) return true; else return false; }
            inline bool                         operator != (const char *NuevoString)                                                       { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const std::string &NuevoString)                                                { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const DStringMB &NuevoString)                                                  { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const wchar_t *NuevoString)                                                    { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const std::wstring &NuevoString)                                               { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }
            inline bool                         operator != (const DStringWC &NuevoString)                                                  { int C = Comparar(NuevoString); if (C == 0) return false; else return true; }

            virtual const TCHAR                *Objeto_Nombre(void) { return TEXT("DStringWC"); };
            virtual const DEnum_Objeto          Objeto_ID(void)     { return DEnum_Objeto_StringWC; };
          protected :
            const size_t                       _AgregarStringMultiByte(const char *NuevoString, const size_t NewSize = DWL_STR_MAX);
            inline const size_t                _AgregarStringMultiByte(const std::string &NuevoString)                                      { return _AgregarStringMultiByte(NuevoString.c_str(), NuevoString.size()); };
            inline const size_t                _AgregarStringMultiByte(const DStringMB &NuevoString)                                        { return _AgregarStringMultiByte(NuevoString(), NuevoString.Tam()); };
            const int                          _CompararBinario(const wchar_t *String1, const wchar_t *String2) const;
            const int                          _CompararInsensitivo(const wchar_t *String1, const wchar_t *String2) const;
            std::wstring                       _Text;
        };

    };

#endif    /* MString_H */

